create database UNIS 
go

create database UNIS
on primary
(filename = 'C:\Program Files\Microsoft SQL Server\MSSQL$UNIS\Data\unis.mdf')
for attach
go 

use unis
go

exec sp_dropuser N'unisuser'
go

exec sp_addlogin N'unisuser', 'unisamho', N'unis', N'us_english'
go

EXEC sp_grantdbaccess N'unisuser', N'unisuser'	
go

exec sp_addrolemember N'db_owner', N'unisuser'
go

sp_password @old=null,@new='unisamho',@loginame='unisuser'
go

CREATE TABLE iUserFinger(
	L_UID int NOT NULL,
	L_IsWideChar int NULL,
	B_TextFIR image NULL
)
GO

ALTER TABLE iUserFinger ADD 
	CONSTRAINT PK_iUserFinger PRIMARY KEY  CLUSTERED 
	(
		L_UID 
	)  
GO

CREATE TABLE tClientLog(
	C_EventTime char(14) NULL,
	L_LogonID int NULL,
	L_Type int NULL,
	L_Result int NULL
)
GO

CREATE TABLE tTerminalLog(
	C_EventTime char(14) NULL,
	L_TID int NULL,
	L_Type int NULL
) 
GO

CREATE TABLE tEnter(
	C_Date char(8) NOT NULL,
	C_Time char(6) NOT NULL,
	L_TID int NOT NULL,
	L_UID int NOT NULL,
	C_Name varchar(30) NULL,
	C_Unique varchar(20) NULL,
	C_Office varchar(30) NULL,
	C_Post varchar(30) NULL,
	C_Card varchar(24) NULL,
	L_UserType int NULL,
	L_Mode int NULL,
	L_MatchingType int NULL,
	L_Result int NULL,
	L_IsPicture int NULL
)
GO

ALTER TABLE tEnter ADD 
	CONSTRAINT PK_tEnter PRIMARY KEY  CLUSTERED 
	(
		C_Date,
		C_Time,
		L_TID,
		L_UID
	)  
GO

CREATE TABLE tAuditTerminal(
	C_EventTime char(14) NOT NULL,
	L_TID int NOT NULL,
	L_AdminID int NOT NULL,
	C_AdminName varchar(30) NULL,
	L_Type int NOT NULL,
	L_UserID int NOT NULL,
	C_UserName varchar(30) NULL
) 
GO

ALTER TABLE tAuditTerminal ADD 
	CONSTRAINT PK_tAuditTerminal PRIMARY KEY  CLUSTERED 
	(
		C_EventTime, 
		L_TID,
		L_AdminID,
		L_Type,
		L_UserID  
	)  
GO

CREATE TABLE tAuditServer(
	C_EventTime char(14) NOT NULL,
	L_LogonID int NOT NULL,
	L_Section int NULL,
	C_Target varchar(30) NULL,
	L_Process int NULL,
	L_Detail int NULL
) 
GO


CREATE TABLE cHoliday(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE cHoliday ADD 
	CONSTRAINT PK_cHoliday PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE cOffice(
	c_code varchar(30) NOT NULL,
	c_name varchar(30) NULL
) 
GO

ALTER TABLE cOffice ADD 
	CONSTRAINT PK_cOffice PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE cPost(
	c_code varchar(30) NOT NULL,
	c_name varchar(30) NULL
) 
GO

ALTER TABLE cPost ADD 
	CONSTRAINT PK_cPost PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE cStaff(
	C_Code varchar(30) NOT NULL,
	C_Name varchar(30) NULL
) 
GO

ALTER TABLE cStaff ADD 
	CONSTRAINT PK_cStaff PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE iCantTerminal(
	L_UID int NULL,
	L_TID int NULL
) 
GO

CREATE TABLE iHoliday(
	C_Code char(4) NOT NULL,
	C_Holiday char(4) NULL,
	C_DayName varchar(30) NULL
) 
GO

CREATE TABLE iTerminalAdmin(
	L_TID int NOT NULL,
	L_UID int NOT NULL
) 
GO

ALTER TABLE iTerminalAdmin ADD 
	CONSTRAINT PK_iTerminalAdmin PRIMARY KEY  CLUSTERED 
	(
		L_TID, 
		L_UID 
	)  
GO

CREATE TABLE tCmdDown(
	C_RegTime char(14) NOT NULL,
	L_TID int NOT NULL,
	L_UID int NOT NULL,
	C_Time char(14) NULL,
	B_Data image NULL,
	L_Retry int NULL
) 
GO

ALTER TABLE tCmdDown ADD 
	CONSTRAINT PK_tCmdDown PRIMARY KEY  CLUSTERED 
	(
		C_RegTime,
		L_TID,
		L_UID
	)  
GO

CREATE TABLE tMealType(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL
) 
GO

ALTER TABLE tMealType ADD 
	CONSTRAINT PK_tMealType PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE tMoney(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	L_Unit int NULL,
	L_Early int NULL,
	L_Basic int NULL,
	L_Over int NULL,
	L_Night int NULL,
	L_Holi int NULL
) 
GO

ALTER TABLE tMoney ADD 
	CONSTRAINT PK_tMoney PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE tWorkType(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	C_BasicDay char(8) NULL,
	L_Spin int NULL,
	C_WorkCode varchar(60) NULL,
	L_InoutMode int NULL,
	L_AutoIn int NULL,
	L_AutoOut int NULL,
	L_LateMargin int NULL,
	L_LackMargin int NULL,
	C_HoliCode char(4) NULL
) 
GO

ALTER TABLE tWorkType ADD 
	CONSTRAINT PK_tWorkType PRIMARY KEY  CLUSTERED 
	(
		C_Code 
	)  
GO

CREATE TABLE iUserPicture(
	L_UID int NOT NULL,
	B_Picture image NULL
) 
GO

ALTER TABLE iUserPicture ADD 
	CONSTRAINT PK_iUserPicture PRIMARY KEY  CLUSTERED 
	(
		L_UID
	)  
GO

CREATE TABLE tConfig(
	C_MasterPwd varchar(30) NULL,
	L_UniqueType int NULL,
	L_AutoDown int NULL,
	C_DownTime char(4) NULL,
	L_AutoUp int NULL,
	L_RegSameFp int NULL,
	L_FpNum int NULL,
	L_UidCipher int NULL,
	L_TidCipher int NULL,
	L_UniqueCipher int NULL,
	L_MinVID int NULL,
	L_MaxVID int NULL,
	L_tSockPort int NULL,
	L_PollTime int NULL,
	L_SaveMode int NULL,
        C_PicturePath varchar(255)
) 
GO

CREATE TABLE iTimezone(
	C_Code char(4) NOT NULL,
	C_Timezone char(8) NOT NULL
) 
GO


CREATE TABLE cTimezone(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NOT NULL,
	L_Flag int NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE cTimezone ADD 
	CONSTRAINT PK_cTimezone PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO

CREATE TABLE cAccessTime(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	L_Flag int NULL,
	C_Holiday char(4) NULL,
	C_Sun char(4) NULL,
	C_Mon char(4) NULL,
	C_The char(4) NULL,
	C_Wed char(4) NULL,
	C_Thu char(4) NULL,
	C_Fri char(4) NULL,
	C_Sat char(4) NULL,
	C_Hol char(4) NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE cAccessTime ADD 
	CONSTRAINT PK_cAccessTime PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO

CREATE TABLE iAccessArea(
	C_Code char(4) NOT NULL,
	L_TID int NOT NULL
) 
GO

ALTER TABLE iAccessArea ADD 
	CONSTRAINT PK_iAccessArea PRIMARY KEY  CLUSTERED 
	(
		C_Code,
		L_TID
	)  
GO

CREATE TABLE cAccessArea(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	L_Flag int NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE cAccessArea ADD 
	CONSTRAINT PK_cAccessArea PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO

CREATE TABLE cAccessGroup(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	L_Flag int NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE cAccessGroup ADD 
	CONSTRAINT PK_cAccessGroup PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO

CREATE TABLE iAccessGroup(
	C_Code char(4) NOT NULL,
	L_Type int NOT NULL,
	C_AccessCode char(4) NOT NULL
) 
GO

CREATE TABLE tUser(
	L_ID int NOT NULL,
	C_Name varchar(30) NULL,
	C_Unique varchar(20) NULL,
	L_Type int NULL,
	C_RegDate char(14) NULL,
	L_OptDateLimit int NULL,
	C_DateLimit char(16) NULL,
	L_AccessType int NULL,
	C_Password varchar(8) NULL,
	L_Identify int NULL,
	L_VerifyLevel int NULL,
	C_AccessGroup char(4) NULL,
	C_PassbackStatus char(4) NULL
) 
GO

ALTER TABLE tUser ADD 
	CONSTRAINT PK_tUser PRIMARY KEY  CLUSTERED 
	(
		L_ID 
	)  
GO

CREATE TABLE tEmploye(
	L_UID int NOT NULL,
	C_IncludeDate char(8) NULL,
	C_RetiredDate char(8) NULL,
	C_Office varchar(30) NULL,
	C_Post varchar(30) NULL,
	C_Staff varchar(30) NULL,
	C_Authority char(4) NULL,
	C_Work char(4) NULL,
	C_Money char(4) NULL,
	C_Meal char(4) NULL,
	C_Phone varchar(255) NULL,
	C_Email varchar(255) NULL,
	C_Address varchar(255) NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE tEmploye ADD 
	CONSTRAINT PK_tEmploye PRIMARY KEY  CLUSTERED 
	(
		L_UID 
	)  
GO

CREATE TABLE tVisitor(
	L_UID int NOT NULL,
	C_Office varchar(30) NULL,
	C_Post varchar(30) NULL,
	C_Target varchar(30) NULL,
	C_Goal varchar(255) NULL,
	C_Company varchar(30) NULL,
	C_Info varchar(255) NULL,
	C_Phone varchar(255) NULL,
	C_Email varchar(255) NULL,
	C_Address varchar(255) NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE tVisitor ADD 
	CONSTRAINT PK_tVisitor PRIMARY KEY  CLUSTERED 
	(
		L_UID 
	)  
GO

CREATE TABLE tVisited(
	C_Name varchar(30) NULL,
	C_Unique varchar(20) NULL,
	C_RegDate char(14) NULL,
	C_LastDate char(8) NULL,
	C_Company varchar(30) NULL,
	C_Info varchar(255) NULL,
	C_Phone varchar(255) NULL,
	C_Email varchar(255) NULL,
	C_Address varchar(255) NULL,
	C_Remark varchar(255) NULL
) 
GO

CREATE TABLE tTerminal(
	L_ID int NOT NULL,
	C_Name varchar(30) NULL,
	L_FnWork int NULL,
	L_FnMeal int NULL,
	L_FnSchool int NULL,
	C_Office varchar(30) NULL,
	C_Place varchar(255) NULL,
	C_RegDate char(14) NULL,
	L_CommType int NULL,
	C_IPAddr varchar(255) NULL,
	L_IPPort int NULL,
	L_ComPort int NULL,
	L_Baudrate int NULL,
	L_Passback int NULL,
	C_AreaIn char(4) NULL,
	C_AreaOut char(4) NULL,
	C_lastup char(14) NULL,
	C_Version varchar(255) NULL,
	C_Remark varchar(255) NULL
) 
GO

ALTER TABLE tTerminal ADD 
	CONSTRAINT PK_tTerminal PRIMARY KEY  CLUSTERED 
	(
		L_ID 
	)  
GO

CREATE TABLE iCardInfo(
	L_CardSize int NULL,
	L_CardType int NULL,
	L_ReadType int NULL,
	L_TemplateSize int NULL,
	L_TemplateCount int NULL
) 
GO

CREATE TABLE iCardLayout(
	L_Index int NULL,
	L_Sector int NULL,
	L_Block int NULL,
	L_Start int NULL,
	L_Length int NULL,
	L_KeyType int NULL,
	C_KeyValue char(12) NULL
) 
GO

CREATE TABLE iUserCard(
	C_CardNum varchar(24) NOT NULL,
	L_UID int NULL
) 
GO

ALTER TABLE iUserCard ADD 
	CONSTRAINT PK_iUserCard PRIMARY KEY  CLUSTERED 
	(
		C_CardNum 
	)  
GO

CREATE TABLE cAuthority(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	L_SetLocal int NULL,
	L_RegInfo int NULL,
	L_DataBackup int NULL,
	L_MgrTerminal int NULL,
	L_RegControl int NULL,
	L_SetControl int NULL,
	L_RegEmploye int NULL,
	L_ModEmploye int NULL,
	L_OutEmploye int NULL,
	L_RegVisitor int NULL,
	L_OutVisitor int NULL,
	L_RegMoney int NULL,
	L_RegWork int NULL,
	L_SetWork int NULL,
	L_ModWork int NULL,
	L_RegMeal int NULL,
	L_SetMeal int NULL,
	L_ModMeal int NULL,
	L_DelResult int NULL,
	L_DelWork int NULL,
	L_DelMeal int NULL,
	L_MgrScope int NULL
) 
GO

ALTER TABLE cAuthority ADD 
	CONSTRAINT PK_cAuthority PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO

CREATE TABLE cPassback(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	C_Remark varchar(255) NULL
)
GO

ALTER TABLE cPassback ADD 
	CONSTRAINT PK_cPassback PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO


CREATE TABLE tMapImage(
	C_Code char(4) NOT NULL,
	C_Name varchar(30) NULL,
	C_FileName varchar(255) NULL,
	L_FileSize int NULL,
	B_FileData Image NULL
)
GO

ALTER TABLE tMapImage ADD 
	CONSTRAINT PK_tMapImage PRIMARY KEY  CLUSTERED 
	(
		C_Code
	)  
GO

CREATE TABLE iMapDrawing(
	C_MapCode char(4),
	L_PosX int NULL,
	L_PosY int NULL
)
GO

CREATE TABLE iMapTerminal(
	C_MapCode char(4),
	L_TID int NULL,
	L_Type int NULL,
	L_PosX int NULL,
	L_PosY int NULL
)
GO

Insert into tconfig values ('1',1,0,'0000',1,1,3,4,4,20,7000,9999,9870,10,0,'')
Insert into cAuthority values ('****', 'User', 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert into cAuthority values ('1000', 'Department Admin', 0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0)
Insert into cAuthority values ('2000', 'Terminal Admin', 0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1)
Insert into cAuthority values ('3000', 'Branch Admin', 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1)
Insert into cAuthority values ('4000', 'All Admin', 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2)
Insert into cOffice values ('****', 'Unassigned')
Insert into cPost values ('****', 'Unassigned')
Insert into cStaff values ('****', 'Unassigned')
Insert into cAccessGroup values ('****', 'Unassigned',0,'')
Insert into cPassback values ('****', 'Unassigned','')
Insert into cTimezone values ('****', 'Unassigned', 1, '')
Insert into cHoliday values ('****', 'Unassigned', '')
Insert into tMoney values ('****', 'Unassigned', 0,0,0,0,0,0)
Insert into tMealType values ('****', 'Unassigned')
Insert into tWorkType values ('****', 'Unassigned', '', 0, '', 0,0,0,0,0,'')

